/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

float noise( in vec2 x )
{
   vec2 p = floor(x);
   vec2 f = fract(x);
   vec2 uv = p.xy + f.xy*f.xy*(3.0-2.0*f.xy);
   return texture2D( iChannel0, (uv+118.4)/256.0, -100.0 ).x;
}

float fbm( vec2 x) {
    float h = 0.0;

    for (float i=1.0;i<10.0;i++) {
        h+=noise(x*pow(1.6, i))*0.9*pow(0.6, i);
    }
    return h;
}

float warp(vec2 p, float mm) {
    float m = 4.0;
    vec2 q = vec2(fbm(vec2(p)), fbm(p+vec2(5.12*iGlobalTime*0.01, 1.08)));

    vec2 r = vec2(fbm((p+q*m)+vec2(0.1, 4.741)), fbm((p+q*m)+vec2(1.952, 7.845)));
    m /= mm;
    return fbm(p+r*m);
}

void main ( void )
{
   vec2 fragCoord = gl_FragCoord.xy;
   fragCoord+=vec2(iGlobalTime*100.0, 0.0);
   float col = warp(fragCoord*0.004, 12.0+fbm(fragCoord*0.005)*16.0);
   float y = pow(1.0-fragCoord.y/iResolution.y, 2.0);
   gl_FragColor = mix(vec4(0.2+0.3*y, 0.4+0.2*y, 1.0, 1.0), vec4(1.0), smoothstep(0.5, 1.0, col));
}
